/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: dynamic.h
 * Author: Tilmann Wendel 1.9.97
 * Purpose: This file contains the function prototypes for the dynamic
 * capabilities. These functions provide an easy method of checking
 * if an parameter is allowed at all and what the range is.
 * Errors reported range from "Parameter not allowed", "Range exceeded"
 * to "No License for this parameter".
 * ----------------------------------------------------------------------- */
 

#ifndef DYNAMIC_H_INCLUDED
#define DYNAMIC_H_INCLUDED


#include <dyndefs.h>


#define B_INDEX_SEARCH  1
#define B_ENUM_SEARCH   2
#define B_NAME_SEARCH 3
#define B_CLINAME_SEARCH 4


#ifdef __cplusplus
extern "C" {
#endif

/* -----------------------------------------------------------------------
 * Dynamic Capabilities functions
 * ----------------------------------------------------------------------- */

/* initializing and setting the information (and deleting it afterwards) */
b_errtype EXPORT BestCapaInit(
    b_handletype    handle
    );

b_errtype EXPORT BestCapaClose( 
    b_handletype    handle
    );


#ifndef BEST_FIRMWARE

b_errtype EXPORT BestParamProbe (
    b_handletype        handle,
    b_paramtype         param_typ,   /* what kind of parameter at all */      
    b_int32             parnum
    );


/* check a specific parameter if it is within the bounds */
/* used within the C-API to check parameters */
b_errtype EXPORT BestParamCheck(      
    b_handletype        handle,
    b_paramtype         param_typ,   /* what kind of parameter at all */      
    b_int32             prop_typ,    /* the parameter itself (autocast)*/
    b_int32             value        /* and the value */
    );

/* return the generic information struct for one of the blocks */
/* used by the GUI or application to obtain block related information */
b_errtype EXPORT BestGenInfoGet(
    b_handletype handle,
    b_paramtype             param_typ,   /* what kind of param block at all */
    b_generic_infotype **   geninfo    /* the info struct */
    );

/* return the information struct for a specific parameter */
/* used by the GUI or application to obtain parameter related information */
b_errtype EXPORT BestParamInfoGet(
    b_handletype handle,
    b_paramtype           param_typ,   /* what kind of parameter at all */    
    b_int64               parnum,      /* the parameter itself (as a number)*/
    b_param_infotype **   paraminfo,   /* the info struct */ 
    b_int32               option     /*how to search for param(index or enum)*/
    );

#endif


CLI b_errtype EXPORT BestCapabilityCheck( /* @capachk */
    b_handletype        handle,
    b_int32             capa_code   /* @code */
    );

CLI b_errtype EXPORT BestCapabilityRead( /* @caparead */
    b_handletype        handle,
    b_int32       *     capa_code   /* #RETURN "Capabilities: %08x\\h" */
    );

/* ---------- non-CLI exported functions: ------------- */
const b_charptrtype EXPORT BestParamValue2String (
  const b_param_stringlisttype * thelist,
  b_int32 value,
  b_charptrtype retStr
  );

void EXPORT BestParamValueListGet ( const b_param_infotype * pParamInfo,
				    b_int32 minVal,
				    b_int32 maxVal,
				    b_charptrtype buffer );

/* non-CLI not-exported functions */
char * BestDynamicErrorStringGet(b_handletype handle,
				 b_int64 group, 
				 b_int64 param,
				 b_int64 minval, 
				 b_int64 maxval,
				 b_int64 val,
				 b_errtype theerr,
				 char * buf);

/* private function */
b_errtype EXPORT BestIHWCapabilitySet( b_handletype handle,b_int32* capa);
           

#ifdef __cplusplus
}
#endif

#endif
